/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class VWAdminReturnWorkDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener {
    private VWAdminResultPane m_resultsPane;
    private VWSession m_session = null;
    private Frame m_parentFrame = null;
    private Vector m_wobsList = new Vector();
    private JButton m_okButton = null;
    private JButton m_applyButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private boolean m_bCanceled = true;
    private boolean m_bLocked = false;
    private VWTable m_table = null;
    private MyTableModel m_tableModel = null;
    private JScrollPane m_scrollPane = null;
    private JTextArea m_commentsUI = null;
    private JTextArea m_newCommentsUI = null;
    private JRadioButton m_appendRadio = null;
    private JRadioButton m_replaceRadio = null;

    public VWAdminReturnWorkDialog(Vector selectedWork, VWAdminResultPane resultsPane) {
        super(resultsPane.getParentFrame());
        this.m_parentFrame = resultsPane.getParentFrame();
        this.m_session = resultsPane.getSession();
        this.m_wobsList = selectedWork;
        this.m_resultsPane = resultsPane;
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        Dimension dim = VWStringUtils.stringToDimension("665,445");
        if (dim == null) {
            dim = new Dimension(600, 400);
        }
        this.setSize(dim.width, dim.height);
        this.setTitle(VWResource.s_returnWorkDlgTitle);
        this.setVisible(false);
        this.setLocationRelativeTo(this.m_parentFrame);
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.disableControls();
        this.addWindowListener(new VWWindowAdapter(this));
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_okButton) {
            this.returnWork();
            this.m_bCanceled = false;
            this.setVisible(false);
        } else if (object == this.m_applyButton) {
            this.returnWork();
            this.refreshPanel();
        } else if (object == this.m_cancelButton) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage("admin/vwadminreturnworkdialog.htm");
        }
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bCanceled = true;
    }

    protected boolean getStatus() {
        return this.m_bCanceled;
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel();
        try {
            mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            mainPanel.add((Component)this.setupFromToListPanel(), c);
            c.gridx = 0;
            ++c.gridy;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 0.4;
            mainPanel.add((Component)this.setupCommentsPanel(), c);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel setupFromToListPanel() {
        JPanel panel = new JPanel();
        try {
            this.m_tableModel = new MyTableModel(this.m_wobsList);
            this.m_table = new VWTable(this.m_tableModel);
            this.m_table.setPreferredScrollableViewportSize(new Dimension(500, 100));
            this.m_table.setShowGrid(false);
            this.addListenerForRowSelectionChanged();
            this.m_scrollPane = new JScrollPane(this.m_table);
            panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 5, 2);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.fill = 0;
            c.weighty = 0.0;
            JLabel m_participantsLabel = new JLabel(VWResource.s_fromColon);
            panel.add((Component)m_participantsLabel, c);
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)this.m_scrollPane, c);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel setupCommentsPanel() {
        JPanel panel = new JPanel();
        try {
            JLabel commentsLabel = new JLabel(VWResource.s_currentComments);
            JLabel newCommentsLabel = new JLabel(VWResource.s_enterComments);
            this.m_commentsUI = new JTextArea();
            this.m_commentsUI.setText("");
            this.m_commentsUI.setLineWrap(true);
            this.m_commentsUI.setWrapStyleWord(false);
            this.m_commentsUI.setRows(4);
            this.m_newCommentsUI = new JTextArea();
            this.m_newCommentsUI.setText("");
            this.m_newCommentsUI.setLineWrap(true);
            this.m_newCommentsUI.setWrapStyleWord(false);
            this.m_newCommentsUI.setRows(4);
            ButtonGroup grp = new ButtonGroup();
            this.m_appendRadio = new JRadioButton(VWResource.s_append, true);
            this.m_appendRadio.addActionListener(this);
            this.m_replaceRadio = new JRadioButton(VWResource.s_replace);
            this.m_replaceRadio.addActionListener(this);
            grp.add(this.m_appendRadio);
            grp.add(this.m_replaceRadio);
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.s_comments));
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 23;
            c.insets = new Insets(0, 2, 0, 30);
            panel.add((Component)this.m_appendRadio, c);
            c.gridx = 1;
            c.gridwidth = 0;
            panel.add((Component)this.m_replaceRadio, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.fill = 0;
            panel.add((Component)commentsLabel, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            panel.add((Component)new JScrollPane(this.m_commentsUI), c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.fill = 0;
            panel.add((Component)newCommentsLabel, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            panel.add((Component)new JScrollPane(this.m_newCommentsUI), c);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        try {
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 2, 6, 6);
            this.m_okButton = new JButton(VWResource.s_OK);
            this.m_okButton.addActionListener(this);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_applyButton = new JButton(VWResource.s_apply);
            this.m_applyButton.addActionListener(this);
            buttonPanel.add((Component)this.m_applyButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return buttonPanel;
    }

    private void disableControls() {
        this.m_applyButton.setEnabled(false);
        this.m_okButton.setEnabled(false);
    }

    private void resetControls() {
        this.m_table.clearSelection();
        this.refreshCurrentCommentsPanel();
        this.setButtonState();
    }

    private void updateControls() {
        this.refreshCurrentCommentsPanel();
        this.setButtonState();
    }

    private void setButtonState() {
        boolean bEnable = false;
        if (this.m_table.getSelectedRowCount() > 0) {
            bEnable = true;
        }
        this.m_applyButton.setEnabled(bEnable);
        this.m_okButton.setEnabled(bEnable);
    }

    private void refreshCurrentCommentsPanel() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            if (selectedRows.length <= 0) {
                this.m_commentsUI.setText("");
            } else if (this.isUniqueComments()) {
                DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[0]);
                this.m_commentsUI.setText(data.getCurrentComments());
            } else {
                this.m_commentsUI.setText(VWResource.s_variousValues);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addListenerForRowSelectionChanged() {
        ListSelectionModel rowSM = this.m_table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    VWAdminReturnWorkDialog.this.disableControls();
                } else if (!e.getValueIsAdjusting()) {
                    VWAdminReturnWorkDialog.this.updateControls();
                }
            }
        });
    }

    private boolean isUniqueComments() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[i]);
                String comments = data.getCurrentComments();
                for (int j = 0; j < selectedRows.length; ++j) {
                    DataObject anotherData;
                    String anotherComment;
                    if (i == j || VWStringUtils.compare(comments, anotherComment = (anotherData = (DataObject)this.m_tableModel.getObjectAt(selectedRows[j])).getCurrentComments()) == 0) continue;
                    return false;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    private void returnWork() {
        try {
            int[] selectedRows = this.m_table.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                DataObject data = (DataObject)this.m_tableModel.getObjectAt(selectedRows[i]);
                VWWorkObject wob = data.getWob();
                String comments = data.getCurrentComments();
                comments = this.m_appendRadio.isSelected() ? comments + this.m_newCommentsUI.getText() : this.m_newCommentsUI.getText();
                wob.setFieldValue("F_Comment", comments, true);
                wob.doSave(false);
                wob.doReturnToSource();
                wob.doRefresh(true, true);
                VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
                if (woData == null) continue;
                woData.updateLockedInfo();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
    }

    private void refreshPanel() {
        try {
            this.m_tableModel.refreshTable();
            this.m_table.tableChanged(null);
            this.m_table.setSize(this.m_scrollPane.getSize());
            this.m_table.sizeColumnsToFit(-1);
            this.resetControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private Vector m_columnNames = new Vector();
        private Vector m_rowCache = new Vector();
        private Vector m_wobsList;

        public MyTableModel(Vector wobsList) {
            this.m_wobsList = wobsList;
            this.initColumns();
            this.initRowData();
        }

        public int getColumnCount() {
            return this.m_columnNames.size();
        }

        public int getRowCount() {
            return this.m_rowCache.size();
        }

        public String getColumnName(int col) {
            if (col < this.getColumnCount()) {
                return (String)this.m_columnNames.elementAt(col);
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            DataObject data = (DataObject)this.m_rowCache.elementAt(row);
            Vector rowData = data.getRowData();
            if (rowData != null) {
                return rowData.elementAt(col);
            }
            return null;
        }

        public Object getObjectAt(int row) {
            return (DataObject)this.m_rowCache.elementAt(row);
        }

        private void initColumns() {
            this.m_columnNames.addElement(VWResource.s_participantName);
            this.m_columnNames.addElement(VWResource.s_queue);
            this.m_columnNames.addElement(VWResource.s_stepLabel);
            this.m_columnNames.addElement(VWResource.s_subject);
            this.m_columnNames.addElement(VWResource.s_returnToSource);
        }

        private void initRowData() {
            try {
                this.m_rowCache.removeAllElements();
                for (int i = 0; i < this.m_wobsList.size(); ++i) {
                    VWWorkObject wob = ((VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i)).getWob();
                    DataObject obj = new DataObject(wob);
                    if (!obj.canReturnToSource()) continue;
                    this.m_rowCache.addElement(new DataObject(wob));
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }

        private void refreshTable() {
            this.initRowData();
        }
    }

    class DataObject {
        private Vector m_rowData = new Vector();
        private String m_currentComments = null;
        private VWWorkObject m_wob = null;
        private VWStepElement m_stepElement = null;

        public DataObject(VWWorkObject wob) {
            try {
                this.m_wob = wob;
                this.refreshData();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }

        private void refreshData() {
            try {
                this.m_wob.doRefresh(true, true);
                this.m_stepElement = this.m_wob.fetchStepElement();
                this.m_rowData.removeAllElements();
                VWParticipantItem pItem = new VWParticipantItem(this.m_wob.getParticipantNamePx());
                this.m_rowData.addElement(pItem.getDisplayName());
                this.m_rowData.addElement(this.m_wob.getCurrentQueueName());
                this.m_rowData.addElement(this.m_wob.getStepName());
                this.m_rowData.addElement(this.m_wob.getSubject());
                this.m_currentComments = this.m_wob.getComment();
                this.m_rowData.addElement("Some source name");
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
            }
        }

        private boolean canReturnToSource() {
            try {
                return this.m_stepElement.getCanReturnToSource();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
                return false;
            }
        }

        private Vector getRowData() {
            return this.m_rowData;
        }

        private VWWorkObject getWob() {
            return this.m_wob;
        }

        private String getCurrentComments() {
            return this.m_currentComments;
        }
    }
}

